<?php if(!defined('IN_GS')){ die('you cannot load this page directly.'); }
/****************************************************
*
* @File: 		page-sidebar.php
* @Package:		GetSimple
* @Action:		Bootstrap 3GS theme for GetSimple CMS
*
*****************************************************/
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title><?php get_site_name(); ?> | <?php get_page_clean_title(); ?></title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <?php get_header(); ?>

	<!--link rel="stylesheet/less" href="<?php get_theme_url(); ?>/less/bootstrap.less" type="text/css" /-->
	<!--link rel="stylesheet/less" href="<?php get_theme_url(); ?>/less/responsive.less" type="text/css" /-->
	<!--script src="<?php get_theme_url(); ?>/js/less-1.3.3.min.js"></script-->
	<!--append ‘#!watch’ to the browser URL, then refresh the page. -->
	
	<link href="<?php get_theme_url(); ?>/css/bootstrap.min.css" rel="stylesheet">
	<link href="<?php get_theme_url(); ?>/css/style.css" rel="stylesheet">

  <!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
  <!--[if lt IE 9]>
    <script src="<?php get_theme_url(); ?>/js/html5shiv.js"></script>
  <![endif]-->

  <!-- Fav and touch icons -->
  <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php get_theme_url(); ?>/img/apple-touch-icon-144-precomposed.png">
  <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php get_theme_url(); ?>/img/apple-touch-icon-114-precomposed.png">
  <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php get_theme_url(); ?>/img/apple-touch-icon-72-precomposed.png">
  <link rel="apple-touch-icon-precomposed" href="<?php get_theme_url(); ?>/img/apple-touch-icon-57-precomposed.png">
  <link rel="shortcut icon" href="<?php get_theme_url(); ?>/img/favicon.png">
  
	<script type="text/javascript" src="<?php get_theme_url(); ?>/js/jquery.min.js"></script>
	<script type="text/javascript" src="<?php get_theme_url(); ?>/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="<?php get_theme_url(); ?>/js/scripts.js"></script>
</head>

<body>
<div class="container">
	<div class="row clearfix">
		<div class="col-md-12 column">
			<div class="page-header">
				<h1>
					<?php get_site_name(); ?> <small><?php get_component( 'tagline' ); ?></small>
				</h1>
			</div>
			<ul class="nav nav-pills">
				<?php get_navigation(return_page_slug(FALSE)); ?>
			</ul><br /><br />
			<ul class="breadcrumb">
				<li>
					<a href="<?php get_site_url(); ?>"><?php get_site_name(); ?></a> <span class="divider">/</span>
				</li>
				<li class="active">
					<?php get_page_title(); ?>
				</li>
			</ul>
			<div class="row clearfix">
				<div class="col-md-8 column">
					<h2>
						<?php get_page_title(); ?>
					</h2>
					<?php get_page_content(); ?>
				</div>
				<div class="col-md-4 column">
					<p>
						<?php get_component( 'sidebar' ); ?>
					</p>
				</div>
			</div>
		</div>
	</div>
	<?php get_footer(); ?>
	<div class="row clearfix">
		<div class="col-md-6 column">
			<p class="text-muted"><small>Copyright &copy; 2015 <?php get_site_name(); ?>. All rights reserved. <?php get_site_credits(); ?></small></p>
		</div>
		<div class="col-md-6 column">
			<p class="text-right text-muted"><small>Design by <a href="http://talbott.ga" target="_blank">T4L80TT</a></small></p>
		</div>
	</div>
</div>
</body>
</html>
